<?php
require_once "../Api.php";
require "./get/getAutomation.php";
require "./put/updateAutomation.php";
require "./post/createAutomation.php";
require "./patch/changeAutomation.php";
require "./delete/deleteAutomation.php";

class automationApi extends Api
{
   public $apiName = "automation";

   /**
    * Метод GET
    * Вывод списка всех записей
    * http://ДОМЕН/Channels
    * @return string
    */
   public function getAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "events":
               return getEvents();
               break;
            case "macros":
               return isset($id) ? getMacrosList($id) : getMacros();
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод POST
    * Создание новой записи
    * http://ДОМЕН/Channels
    * @return string
    */
   public function createAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "events":
               changeEvents();
               break;
            case "macros":
               changeMacros();
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод PATCH
    * Создание новой записи
    * http://ДОМЕН/Channels
    * @return string
    */
   public function changeAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "channels":
               break;
            case "state":
               break;
            case "timezones":
               break;
            case "rotate":
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод PUT
    * Обновление отдельной записи (по ее id)
    * http://ДОМЕН/Channels
    * @return string
    */
   public function updateAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "channels":
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод DELETE
    * Удаление отдельной записи (по ее id)
    * http://ДОМЕН/Channels
    * @return string
    */
   public function deleteAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "channels":
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }
}
